---
title: "Running things in gem5"
author: Maryam Babaie
slides_code: "using-gem5-03-gem5-running-tutorial.pdf"
livestream_code: 7QX-QdBtFGY
example_code: /materials/using-gem5/03-running
---

## Non-code-based execution

- Traffic generators
  - Show how to connet
  - Maybe an assignment

## SE mode

- What's needed for SE mode
  - SE mode uses the *host* for many things
  - Demonstrate that printf takes 0 time in gem5?
  - Maybe an example where you see the size of a file and/or list a directory to show that gem5 is using the host FS
  - Show the syscall implementation in `src/sim/syscall..`
- SE mode file services and redirects

## m5 magic utility

- How magic instructions work (and why magic instructions)
- How to build the library
- How to link to it
- How to build the utility (to be used in FS mode...)
- Might want to look at where they are implemented.

## Cross compiling from one arch to another

## Building gem5 for different ISAs

- x86
- Arm
- RISC-V
- Also, PPC/SPARC

## How to change the parameters of sim object
- mentioned by Jason
- e.g., traffGen

## Other things not covered

- How to use traces
  - Run a workload, save the memory trace
  - Replay the memory trace
- SE mode drivers
- SE mode page tables/mmap
